﻿//============================================
// filename: main.c
// chip    : CSU38F20
// author  :
// date    : 2020-12-16
//============================================
#include "CSU38F20.h"

unsigned char key_detect = 0;
unsigned char led_display_type = 0;
//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(E0IE && E0IF)
	{
		E0IF = 0;
		key_detect = 1;
	}
}

//============================================
// program start
//============================================
void main()
{
	unsigned char key_press = 0;
	unsigned int key_flit = 0;
	PT1EN = 0;		//设置PT1.0为数字输入口，接30K上拉
	PT1PU = 0b00000001;
	PT1CON1 = 0;
	PT1 = 0;
	
	INTF = 0;
	INTF2 = 0;
	INTE = 0b10000001;	//使能总中断、外部中断0
	INTE2 = 0;
	PT1CON = 0;		//外部中断0为下降沿触发
	INTCFG = 0b10000000;	//使能PT1.0外部中断0
	
	while(1)
	{
		LEDCON = 0b10010011;
		PT5_BIGDRV = 0;
		
		if(key_detect)
		{
			if(!PT1_0)
			{
				if(++key_flit >= 4000)
				{
					key_flit = 0;
					key_detect = 0;
					key_press = 1;
					led_display_type = ~led_display_type;
				}
			}
			else
			{
				key_flit = 0;
				key_detect = 0;
			}
		}
		else
		{
			key_flit = 0;
		}
		
		
		if(key_press)		//按下按键，LED亮灭切换
		{
			key_press = 0;
			if(led_display_type)
			{
				for(unsigned char i=0;i<=7;i++)		//LED扫描全亮子程序
				{
					LEDADR = i;
					switch (i)
					{
						case 0:LEDDAT = 0b11111110;break;
						case 1:LEDDAT = 0b11111101;break;
						case 2:LEDDAT = 0b11111011;break;
						case 3:LEDDAT = 0b11110111;break;
						case 4:LEDDAT = 0b11101111;break;
						case 5:LEDDAT = 0b11011111;break;
						case 6:LEDDAT = 0b10111111;break;
						case 7:LEDDAT = 0b01111111;break;
					}
					LEDCON1 = 0x01;		 //驱动电流均设为10mA
					LEDDUTY = 0x1F;		//占空比均设为32/32
				}
			}
			else
			{
				for(unsigned char i=0;i<=7;i++)		//LED扫描全灭子程序
				{
					LEDADR = i;
					switch (i)
					{
						case 0:LEDDAT = 0;break;
						case 1:LEDDAT = 0;break;
						case 2:LEDDAT = 0;break;
						case 3:LEDDAT = 0;break;
						case 4:LEDDAT = 0;break;
						case 5:LEDDAT = 0;break;
						case 6:LEDDAT = 0;break;
						case 7:LEDDAT = 0;break;
					}
					LEDCON1 = 0x01;		//驱动电流均设为10mA
					LEDDUTY = 0x1F;		//占空比均设为32/32
				}
			}
		}
	}
}